#!/usr/bin/env python
"""
Automatyzowanie domu: wysyłanie e-maili z załączonym zdjęciem
Projekt na Raspberry Pi
"""

import sys
import smtplib
from email.mime.text import MIMEText
from email.mime.application import MIMEApplication
from email.mime.multipart import MIMEMultipart

def emailphoto(msgtext, afilename):
        # W cudzysłowiu umieść nazwę konta e-mail
        smtp_user = ""
        
        # W cudzysłowiu umieść hasło do konta e-mail
        smtp_pass = "" 
        msg = MIMEMultipart() 
        
        # W cudzysłowiu umieść docelowy adres e-mail
        msg['To']   = "" 
        
        # W cudzysłowiu umieść nazwę konta e-mail 
        msg['From'] = "" 
        
        # W cudzysłowiu umieść temat wiadomości
        msg['Subject'] = "" 
        
        # Tę informację zobaczy użytkownik, który nie ma klienta poczty elektronicznej  
        msg.preamble = 'Wieloczęściowa wiadomość.\n'  
        
        # sys.argv[1] to pierwszy parametr przekazany do programu.
        # Zawiera tekst ciała wiadomości e-mail
        part = MIMEText(msgtext) 
        msg.attach(part)        
        
        # Trzy poniższe wiersze dołączają zdjęcie z pliku, którego
        # nazwę przekazano jako drugi parametr programu
        part = MIMEApplication(open(afilename,"rb").read())
        part.add_header('Content-Disposition', 'attachment', filename=afilename)
        msg.attach(part)
        
        # Między cudzysłowami podaj adres URL lub IP serwera SMTP
        s = smtplib.SMTP_SSL("", 465) 
        s.login(smtp_user,smtp_pass)
        s.sendmail(msg['From'], msg['To'], msg.as_string())
        s.quit()

def main():
    emailphoto(sys.argv[1], sys.argv[2])

if __name__ == "__main__":
        main()